/*
 * Decompiled with CFR 0.152.
 */
package GLOOP;

import GLOOP.GLGlobal;
import GLOOP.GLObjekt;
import GLOOP.GLTextur;
import GLOOP.GLVektor;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;

public class GLKugel
extends GLObjekt {
    float zRadius;
    int zQualitaet = 0;

    public GLKugel(double pX, double pY, double pZ, double pRadius, GLTextur pT) {
        this(pX, pY, pZ, pRadius);
        this.setzeTextur(pT);
    }

    public GLKugel(double pX, double pY, double pZ, double pRadius, String pTextur) {
        this(pX, pY, pZ, pRadius);
        this.setzeTextur(new GLTextur(pTextur));
    }

    public GLKugel(double pX, double pY, double pZ, double pRadius) {
        this.matrix[12] = (float)pX;
        this.matrix[13] = (float)pY;
        this.matrix[14] = (float)pZ;
        this.zRadius = (float)pRadius;
    }

    void berechneQualitaet() {
        double lDist = Math.sqrt(Math.pow((double)this.matrix[12] - GLGlobal.KAMERA.gibX(), 2.0) + Math.pow((double)this.matrix[13] - GLGlobal.KAMERA.gibY(), 2.0) + Math.pow((double)this.matrix[14] - GLGlobal.KAMERA.gibZ(), 2.0));
        this.zQualitaet = (int)(lDist * (double)(250.0f / (this.zRadius * this.skalierung)) * -0.006 + 43.0);
        if (this.zQualitaet < 12) {
            this.zQualitaet = 12;
        }
        if (this.zQualitaet > 40) {
            this.zQualitaet = 40;
        }
    }

    @Override
    public void zeichneObjekt(GL2 gl, GLU glu) {
        if (this.zQualitaet == 0) {
            this.berechneQualitaet();
        }
        for (int i = 0; i < this.zQualitaet; ++i) {
            float lY1 = (float)Math.sin((double)(90 - i * 180 / this.zQualitaet) * Math.PI / 180.0);
            float lY2 = (float)Math.sin((double)(90 - (i + 1) * 180 / this.zQualitaet) * Math.PI / 180.0);
            float lRT1 = (float)Math.cos((double)(90 - i * 180 / this.zQualitaet) * Math.PI / 180.0);
            float lRT2 = (float)Math.cos((double)(90 - (i + 1) * 180 / this.zQualitaet) * Math.PI / 180.0);
            gl.glBegin(8);
            for (int j = 0; j <= this.zQualitaet; ++j) {
                float lX = (float)Math.cos((double)(j * 360 / this.zQualitaet) * Math.PI / 180.0);
                float lZ = (float)Math.sin((double)(j * 360 / this.zQualitaet) * Math.PI / 180.0);
                gl.glNormal3f(lX * lRT1, lZ * lRT1, lY1);
                gl.glTexCoord2f((float)(this.zQualitaet - j) / (float)this.zQualitaet, (float)(this.zQualitaet - i) / (float)this.zQualitaet);
                gl.glVertex3f(lX * this.zRadius * lRT1, lZ * this.zRadius * lRT1, lY1 * this.zRadius);
                gl.glNormal3f(lX * lRT2, lZ * lRT2, lY2);
                gl.glTexCoord2f((float)(this.zQualitaet - j) / (float)this.zQualitaet, (float)(this.zQualitaet - i - 1) / (float)this.zQualitaet);
                gl.glVertex3f(lX * this.zRadius * lRT2, lZ * this.zRadius * lRT2, lY2 * this.zRadius);
            }
            gl.glEnd();
        }
    }

    @Override
    public void setzeQualitaet(int pQ) {
        this.zQualitaet = pQ;
        this.resetDisplayliste();
    }

    public GLKugel(GLVektor pPosition, double pRadius) {
        this(pPosition.x, pPosition.y, pPosition.z, pRadius);
    }

    public GLKugel(GLVektor pPosition, double pRadius, GLTextur pTextur) {
        this(pPosition.x, pPosition.y, pPosition.z, pRadius, pTextur);
    }

    public GLKugel(GLVektor pPosition, double pRadius, String pTextur) {
        this(pPosition.x, pPosition.y, pPosition.z, pRadius, pTextur);
    }
}

