/*
 * Decompiled with CFR 0.152.
 */
package GLOOP;

import GLOOP.GLGlobal;
import GLOOP.GLKonsole;
import GLOOP.GLRenderer;
import GLOOP.GLTextur;
import GLOOP.GLVektor;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.util.Animator;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;

public class GLKamera {
    GLRenderer renderer;
    Animator animator;
    float[] kamData = new float[9];

    public GLKamera() {
        this(0, 0);
    }

    public GLKamera(int pB, int pH) {
        if (GLGlobal.KAMERA == null) {
            int i;
            GLGlobal.KAMERA = this;
            this.renderer = new GLRenderer(pB, pH);
            for (i = 0; i < GLGlobal.mausObjekte.size(); ++i) {
                GLGlobal.mausObjekte.elementAt(i).erstelleListener();
            }
            for (i = 0; i < GLGlobal.tastaturobjekte.size(); ++i) {
                GLGlobal.tastaturobjekte.elementAt(i).erstelleListener();
            }
        } else {
            GLGlobal.KAMERASEC.add(this);
            this.renderer = new GLRenderer(pB, pH);
        }
        this.kamData[0] = 0.0f;
        this.kamData[1] = 0.0f;
        this.kamData[2] = 500.0f;
        this.kamData[3] = 0.0f;
        this.kamData[4] = 0.0f;
        this.kamData[5] = 0.0f;
        this.kamData[6] = 0.0f;
        this.kamData[7] = 1.0f;
        this.kamData[8] = 0.0f;
        if (GLGlobal.KONSOLE == null) {
            GLGlobal.KONSOLE = new GLKonsole();
            GLGlobal.KAMERA.renderer.frame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    GLGlobal.KONSOLE.positioniere();
                }
            });
        }
        if (GLGlobal.ZEICHEN == null) {
            GLGlobal.ZEICHEN = new GLTextur("Zeichen.png");
        }
        this.animator = new Animator((GLAutoDrawable)this.renderer.canvas);
        this.animator.start();
    }

    public void setzePosition(double pX, double pY, double pZ) {
        this.kamData[0] = (float)pX;
        this.kamData[1] = (float)pY;
        this.kamData[2] = (float)pZ;
        this.renderer.setzeKameradaten(this.kamData);
    }

    public void setzeBlickpunkt(double pX, double pY, double pZ) {
        this.kamData[3] = (float)pX;
        this.kamData[4] = (float)pY;
        this.kamData[5] = (float)pZ;
        this.renderer.setzeKameradaten(this.kamData);
    }

    public void setzeScheitelrichtung(double pX, double pY, double pZ) {
        this.kamData[6] = (float)pX;
        this.kamData[7] = (float)pY;
        this.kamData[8] = (float)pZ;
        this.renderer.setzeKameradaten(this.kamData);
    }

    public GLVektor gibScheitelrichtung() {
        GLVektor scheitel = new GLVektor(this.kamData[6], this.kamData[7], this.kamData[8]);
        scheitel.normiere();
        return scheitel;
    }

    public void aus() {
        this.renderer.an = false;
        this.erstelleEinzelbild();
    }

    public void an() {
        this.renderer.an = true;
    }

    public void erstelleEinzelbild() {
        this.renderer.canvas.swapBuffers();
    }

    public void rotiere(double pWinkel, double pNX, double pNY, double pNZ, double pRX, double pRY, double pRZ) {
        float n = (float)Math.sqrt(pNX * pNX + pNY * pNY + pNZ * pNZ);
        float x = (float)pNX / n;
        float y = (float)pNY / n;
        float z = (float)pNZ / n;
        this.kamData[0] = (float)((double)this.kamData[0] - pRX);
        this.kamData[1] = (float)((double)this.kamData[1] - pRY);
        this.kamData[2] = (float)((double)this.kamData[2] - pRZ);
        this.kamData[3] = (float)((double)this.kamData[3] - pRX);
        this.kamData[4] = (float)((double)this.kamData[4] - pRY);
        this.kamData[5] = (float)((double)this.kamData[5] - pRZ);
        float[] lD = new float[9];
        float c = (float)Math.cos(pWinkel / 180.0 * Math.PI);
        float s = (float)Math.sin(pWinkel / 180.0 * Math.PI);
        lD[0] = (y * y + z * z) * c + x * x;
        lD[1] = x * y * (1.0f - c) + z * s;
        lD[2] = x * z * (1.0f - c) - y * s;
        lD[3] = x * y * (1.0f - c) - z * s;
        lD[4] = (x * x + z * z) * c + y * y;
        lD[5] = y * z * (1.0f - c) + x * s;
        lD[6] = x * z * (1.0f - c) + y * s;
        lD[7] = y * z * (1.0f - c) - x * s;
        lD[8] = (x * x + y * y) * c + z * z;
        float[] lK = new float[9];
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 3; ++k) {
                int n2 = j;
                lK[n2] = lK[n2] + this.kamData[k] * lD[k * 3 + j];
                int n3 = j + 3;
                lK[n3] = lK[n3] + this.kamData[k + 3] * lD[k * 3 + j];
                int n4 = j + 6;
                lK[n4] = lK[n4] + this.kamData[k + 6] * lD[k * 3 + j];
            }
        }
        this.kamData = lK;
        this.kamData[0] = (float)((double)this.kamData[0] + pRX);
        this.kamData[1] = (float)((double)this.kamData[1] + pRY);
        this.kamData[2] = (float)((double)this.kamData[2] + pRZ);
        this.kamData[3] = (float)((double)this.kamData[3] + pRX);
        this.kamData[4] = (float)((double)this.kamData[4] + pRY);
        this.kamData[5] = (float)((double)this.kamData[5] + pRZ);
        this.renderer.setzeKameradaten(this.kamData);
    }

    public void verschiebe(double pX, double pY, double pZ) {
        this.kamData[0] = (float)((double)this.kamData[0] + pX);
        this.kamData[1] = (float)((double)this.kamData[1] + pY);
        this.kamData[2] = (float)((double)this.kamData[2] + pZ);
        this.kamData[3] = (float)((double)this.kamData[3] + pX);
        this.kamData[4] = (float)((double)this.kamData[4] + pY);
        this.kamData[5] = (float)((double)this.kamData[5] + pZ);
        this.renderer.setzeKameradaten(this.kamData);
    }

    public void vor(double pWeite) {
        float n = (float)Math.sqrt(Math.pow(this.kamData[0] - this.kamData[3], 2.0) + Math.pow(this.kamData[1] - this.kamData[4], 2.0) + Math.pow(this.kamData[2] - this.kamData[5], 2.0));
        float x = (this.kamData[0] - this.kamData[3]) / n;
        float y = (this.kamData[1] - this.kamData[4]) / n;
        float z = (this.kamData[2] - this.kamData[5]) / n;
        this.kamData[0] = (float)((double)this.kamData[0] - (double)x * pWeite);
        this.kamData[1] = (float)((double)this.kamData[1] - (double)y * pWeite);
        this.kamData[2] = (float)((double)this.kamData[2] - (double)z * pWeite);
        this.kamData[3] = (float)((double)this.kamData[3] - (double)x * pWeite);
        this.kamData[4] = (float)((double)this.kamData[4] - (double)y * pWeite);
        this.kamData[5] = (float)((double)this.kamData[5] - (double)z * pWeite);
        this.renderer.setzeKameradaten(this.kamData);
    }

    public void schwenkeHorizontal(double pWinkel) {
        this.rotiere(-pWinkel, this.kamData[6], this.kamData[7], this.kamData[8], this.kamData[0], this.kamData[1], this.kamData[2]);
    }

    public void schwenkeVertikal(double pWinkel) {
        float lX = (this.kamData[1] - this.kamData[4]) * this.kamData[8] - (this.kamData[2] - this.kamData[5]) * this.kamData[7];
        float lY = (this.kamData[2] - this.kamData[5]) * this.kamData[6] - (this.kamData[0] - this.kamData[3]) * this.kamData[8];
        float lZ = (this.kamData[0] - this.kamData[3]) * this.kamData[7] - (this.kamData[1] - this.kamData[4]) * this.kamData[6];
        this.rotiere(-pWinkel, lX, lY, lZ, this.kamData[0], this.kamData[1], this.kamData[2]);
    }

    public void loesche() {
        this.animator.stop();
        this.renderer.frame.dispose();
        this.renderer = null;
    }

    public double gibX() {
        return this.kamData[0];
    }

    public double gibY() {
        return this.kamData[1];
    }

    public double gibZ() {
        return this.kamData[2];
    }

    public double gibBlickpunktX() {
        return this.kamData[3];
    }

    public double gibBlickpunktY() {
        return this.kamData[4];
    }

    public double gibBlickpunktZ() {
        return this.kamData[5];
    }

    public void setzeStereomodus(boolean pM) {
        this.renderer.stereomodus = pM;
    }

    public void setzeAugendistanz(double pAugendistanz) {
        this.renderer.augendistanz = pAugendistanz;
    }

    public void zeigeAchsen(boolean pAn) {
        this.renderer.achsen = pAn;
    }

    public int gibBreite() {
        return this.renderer.frame.getWidth();
    }

    public int gibHoehe() {
        return this.renderer.frame.getHeight();
    }

    public void setzeFensterposition(int pX, int pY) {
        this.renderer.frame.setLocation(pX, pY);
    }

    public void zeigeFenster(boolean pS) {
        this.renderer.frame.setVisible(pS);
    }

    public void setzePosition(GLVektor pPos) {
        this.setzePosition(pPos.x, pPos.y, pPos.z);
    }

    public void setzeBlickpunkt(GLVektor pPunkt) {
        this.setzeBlickpunkt(pPunkt.x, pPunkt.y, pPunkt.z);
    }

    public void setzeScheitelrichtung(GLVektor pRich) {
        this.setzeScheitelrichtung(pRich.x, pRich.y, pRich.z);
    }

    public void rotiere(double pWinkel, GLVektor pRichtung, GLVektor pOrt) {
        this.rotiere(pWinkel, pRichtung.x, pRichtung.y, pRichtung.z, pOrt.x, pOrt.y, pOrt.z);
    }

    public void verschiebe(GLVektor pVerschiebung) {
        this.verschiebe(pVerschiebung.x, pVerschiebung.y, pVerschiebung.z);
    }

    public GLVektor gibPosition() {
        return new GLVektor(this.gibX(), this.gibY(), this.gibZ());
    }

    public GLVektor gibBlickpunkt() {
        return new GLVektor(this.gibBlickpunktX(), this.gibBlickpunktY(), this.gibBlickpunktZ());
    }

    public GLVektor gibBlickrichtung() {
        GLVektor lV = this.gibBlickpunkt();
        lV.subtrahiere(this.gibPosition());
        lV.normiere();
        return lV;
    }

    public JFrame gibFrame() {
        return this.renderer.frame;
    }
}

