/*
 * Decompiled with CFR 0.152.
 */
package GLOOP;

import GLOOP.GLElement;
import GLOOP.GLModelkomponente;
import GLOOP.GLOberflaeche;
import GLOOP.GLPrimitiv;
import GLOOP.GLTextur;
import GLOOP.GLVektor;
import GLOOP.GLVertex;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class GLModelverwalter {
    Float[][] positionen;
    Float[][] normalen;
    Float[][] textureKoordinaten;
    GLElement[][] elemente;
    String[] bezeichnungenKomponenten;
    GLTextur[] texturen;

    public GLModelverwalter(String pOBJDatei) {
        this.ladeModel(pOBJDatei);
    }

    public void ladeModel(String pOBJDatei) {
        int countV = 0;
        int countN = 0;
        int countT = 0;
        int countF = 0;
        int countMT = 0;
        int countG = 0;
        String zeile = null;
        GLOberflaeche[] oberflaechen = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pOBJDatei), "UTF8"));
            zeile = reader.readLine();
            while (zeile != null) {
                zeile = zeile.trim();
                while (zeile.indexOf("  ") != -1) {
                    zeile = zeile.replaceAll("  ", " ");
                }
                String[] elem = zeile.split(" ");
                if (elem[0].equals("v")) {
                    ++countV;
                }
                if (elem[0].equals("vt")) {
                    ++countT;
                }
                if (elem[0].equals("vn")) {
                    ++countN;
                }
                if (elem[0].equals("f")) {
                    ++countF;
                }
                if (elem[0].equals("mtllib")) {
                    oberflaechen = this.ladeOberflaechen(elem[1]);
                }
                if (elem[0].equals("g") || elem[0].equals("o")) {
                    ++countG;
                }
                if (elem[0].equals("usemtl")) {
                    ++countMT;
                }
                zeile = reader.readLine();
            }
            reader.close();
        }
        catch (Exception reader) {
            // empty catch block
        }
        if (countG == 0) {
            ++countG;
        }
        this.positionen = new Float[countV][3];
        this.normalen = new Float[countN][3];
        this.textureKoordinaten = new Float[countT][2];
        this.elemente = new GLElement[countG][countF + countMT];
        this.bezeichnungenKomponenten = new String[countG];
        Vector<GLTextur> texTmp = new Vector<GLTextur>();
        for (String string : oberflaechen) {
            if (((GLOberflaeche)((Object)string)).textur == null) continue;
            texTmp.add(((GLOberflaeche)((Object)string)).textur);
        }
        this.texturen = new GLTextur[texTmp.size()];
        for (int i = 0; i < texTmp.size(); ++i) {
            this.texturen[i] = (GLTextur)texTmp.get(i);
        }
        countV = 0;
        countN = 0;
        countT = 0;
        countF = 0;
        countG = 0;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pOBJDatei), "UTF8"));
            zeile = reader.readLine();
            while (zeile != null) {
                zeile = zeile.trim();
                while (zeile.indexOf("  ") != -1) {
                    zeile = zeile.replaceAll("  ", " ");
                }
                String[] elem = zeile.split(" ");
                if (elem[0].equals("g") || elem[0].equals("o")) {
                    this.bezeichnungenKomponenten[++countG - 1] = elem[1];
                }
                if (elem[0].equals("v")) {
                    this.positionen[countV][0] = Float.valueOf(Float.parseFloat(elem[1]));
                    this.positionen[countV][1] = Float.valueOf(Float.parseFloat(elem[2]));
                    this.positionen[countV][2] = Float.valueOf(Float.parseFloat(elem[3]));
                    ++countV;
                }
                if (elem[0].equals("vt")) {
                    this.textureKoordinaten[countT][0] = Float.valueOf(Float.parseFloat(elem[1]));
                    this.textureKoordinaten[countT][1] = Float.valueOf(1.0f - Float.parseFloat(elem[2]));
                    ++countT;
                }
                if (elem[0].equals("vn")) {
                    this.normalen[countN][0] = Float.valueOf(Float.parseFloat(elem[1]));
                    this.normalen[countN][1] = Float.valueOf(Float.parseFloat(elem[2]));
                    this.normalen[countN][2] = Float.valueOf(Float.parseFloat(elem[3]));
                    ++countN;
                }
                if (elem[0].equals("f")) {
                    GLPrimitiv aktPrim = new GLPrimitiv();
                    for (String s : elem) {
                        if (s.equals("f")) continue;
                        if (s.split("/").length == 1) {
                            aktPrim.hinzufuegenVertex(new GLVertex(Integer.parseInt(s.split("/")[0]), -1, -1));
                        }
                        if (s.split("/").length == 2) {
                            aktPrim.hinzufuegenVertex(new GLVertex(Integer.parseInt(s.split("/")[0]), Integer.parseInt(s.split("/")[1]), -1));
                        }
                        if (s.split("/").length != 3) continue;
                        if (!s.split("/")[1].equals("")) {
                            aktPrim.hinzufuegenVertex(new GLVertex(Integer.parseInt(s.split("/")[0]), Integer.parseInt(s.split("/")[1]), Integer.parseInt(s.split("/")[2])));
                            continue;
                        }
                        aktPrim.hinzufuegenVertex(new GLVertex(Integer.parseInt(s.split("/")[0]), -1, Integer.parseInt(s.split("/")[2])));
                    }
                    if (countG == 0) {
                        ++countG;
                    }
                    this.elemente[countG - 1][countF] = aktPrim;
                    ++countF;
                }
                if (elem[0].equals("usemtl")) {
                    GLOberflaeche tmp = null;
                    for (GLOberflaeche a : oberflaechen) {
                        if (!a.gibName().equals(elem[1])) continue;
                        tmp = a;
                    }
                    if (tmp != null) {
                        if (countG == 0) {
                            ++countG;
                        }
                        this.elemente[countG - 1][countF] = tmp;
                        ++countF;
                    }
                }
                zeile = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private GLOberflaeche[] ladeOberflaechen(String pMTLDatei) {
        Vector<GLOberflaeche> oberflaechen = new Vector<GLOberflaeche>();
        try {
            GLOberflaeche aktuell = null;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pMTLDatei), "UTF8"));
            String zeile = reader.readLine();
            while (zeile != null) {
                zeile = zeile.trim();
                while (zeile.indexOf("  ") != -1) {
                    zeile = zeile.replaceAll("  ", " ");
                }
                String[] elem = zeile.split(" ");
                if (elem[0].equals("newmtl")) {
                    if (aktuell != null) {
                        oberflaechen.add(aktuell);
                    }
                    aktuell = new GLOberflaeche(elem[1]);
                }
                if (elem[0].equals("Ka")) {
                    aktuell.ambient[0] = Float.parseFloat(elem[1]);
                    aktuell.ambient[1] = Float.parseFloat(elem[2]);
                    aktuell.ambient[2] = Float.parseFloat(elem[3]);
                }
                if (elem[0].equals("Kd")) {
                    aktuell.diffuse[0] = Float.parseFloat(elem[1]);
                    aktuell.diffuse[1] = Float.parseFloat(elem[2]);
                    aktuell.diffuse[2] = Float.parseFloat(elem[3]);
                }
                if (elem[0].equals("Ks")) {
                    aktuell.spekular[0] = Float.parseFloat(elem[1]);
                    aktuell.spekular[1] = Float.parseFloat(elem[2]);
                    aktuell.spekular[2] = Float.parseFloat(elem[3]);
                }
                if (elem[0].equals("Ns")) {
                    aktuell.haerte = Float.parseFloat(elem[1]);
                }
                if (elem[0].equals("map_Kd")) {
                    aktuell.textur = new GLTextur(elem[elem.length - 1].replace("\\", "/"));
                }
                zeile = reader.readLine();
            }
            if (aktuell != null) {
                oberflaechen.add(aktuell);
            }
        }
        catch (Exception aktuell) {
            // empty catch block
        }
        GLOberflaeche[] ergebnis = new GLOberflaeche[oberflaechen.size()];
        for (int i = 0; i < oberflaechen.size(); ++i) {
            ergebnis[i] = (GLOberflaeche)oberflaechen.get(i);
        }
        return ergebnis;
    }

    public GLModelkomponente[] erzeugeModelkomponenten(double pX, double pY, double pZ) {
        return this.erzeugeModelkomponenten(new GLVektor(pX, pY, pZ));
    }

    public GLModelkomponente[] erzeugeModelkomponenten(GLVektor pPosition) {
        GLModelkomponente[] ergebnis = new GLModelkomponente[this.elemente.length];
        for (int i = 0; i < this.elemente.length; ++i) {
            ergebnis[i] = new GLModelkomponente(pPosition.gibX(), pPosition.gibY(), pPosition.gibZ(), this, i, this.bezeichnungenKomponenten[i]);
        }
        return ergebnis;
    }

    Float[][] gibPositionen() {
        return this.positionen;
    }

    Float[][] gibNormalen() {
        return this.normalen;
    }

    Float[][] gibTexturkoordinaten() {
        return this.textureKoordinaten;
    }

    GLElement[][] gibElemente() {
        return this.elemente;
    }
}

