/*
 * Decompiled with CFR 0.152.
 */
package GLOOP;

import GLOOP.GLDisplayliste;
import GLOOP.GLGlobal;
import GLOOP.GLObjekt;
import GLOOP.GLVektor;
import GLOOP.Sys;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.swing.JFrame;

class GLRenderer
implements GLEventListener {
    String version = "Version 4.31";
    GL2 gl;
    GLU glu;
    GLCanvas canvas;
    JFrame frame;
    double frameCount = 0.0;
    double lastFPS = 0.0;
    double lastFrameTime = 0.0;
    float[] kamData = new float[9];
    float[] renderKamData = new float[9];
    boolean selektionslauf = false;
    double selektionX;
    double selektionY;
    long trefferID = 0L;
    boolean stereomodus = false;
    double augendistanz = 8.0;
    double oeffnungswinkel = 60.0;
    boolean an = true;
    boolean achsen = false;
    boolean gitterdarstellung = false;
    boolean autoSyncMode = true;
    long lastSync;
    double startzeit = System.currentTimeMillis();
    boolean bereit = false;
    double scaleHiDef;

    public GLRenderer(int pB, int pH) {
        this.kamData[0] = 0.0f;
        this.kamData[1] = 0.0f;
        this.kamData[2] = 500.0f;
        this.kamData[3] = 0.0f;
        this.kamData[4] = 0.0f;
        this.kamData[5] = 0.0f;
        this.kamData[6] = 0.0f;
        this.kamData[7] = 1.0f;
        this.kamData[8] = 0.0f;
        this.renderKamData[0] = 0.0f;
        this.renderKamData[1] = 0.0f;
        this.renderKamData[2] = 500.0f;
        this.renderKamData[3] = 0.0f;
        this.renderKamData[4] = 0.0f;
        this.renderKamData[5] = 0.0f;
        this.renderKamData[6] = 0.0f;
        this.renderKamData[7] = 1.0f;
        this.renderKamData[8] = 0.0f;
        GLProfile lProfil = GLProfile.get((String)"GL2");
        GLCapabilities lCaps = new GLCapabilities(lProfil);
        lCaps.setDepthBits(24);
        this.frame = new JFrame("GLOOP, " + this.version + ", QUA-LiS (Autor: Volker Quade), 2022");
        this.frame.setVisible(false);
        if (pB == 0) {
            pH = 3 + (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            pB = 6 + (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            this.frame.setLocation(-3, 0);
        }
        this.frame.setSize(pB, pH);
        this.frame.setResizable(false);
        this.frame.setLayout(null);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        this.scaleHiDef = gc.getDefaultTransform().getScaleX();
        if (this.scaleHiDef == 0.0) {
            this.scaleHiDef = 1.0;
        }
        this.canvas = new GLCanvas((GLCapabilitiesImmutable)lCaps);
        this.canvas.setSize(pB, pH);
        this.canvas.setAutoSwapBufferMode(false);
        this.canvas.setFocusTraversalKeysEnabled(false);
        this.canvas.addGLEventListener((GLEventListener)this);
        this.frame.getContentPane().add((Component)this.canvas);
        this.frame.requestFocus();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Sys.beenden();
            }
        });
        this.frame.setVisible(true);
    }

    public void init(GLAutoDrawable drawable) {
        this.gl = drawable.getGL().getGL2();
        this.glu = new GLU();
        this.gl.glEnable(2929);
        this.gl.glEnable(2884);
        this.gl.glCullFace(1029);
        this.gl.glShadeModel(7425);
        this.gl.glEnable(3042);
        this.gl.glBlendFunc(770, 771);
        this.gl.glEnable(3008);
        this.gl.glAlphaFunc(516, 0.1f);
        this.gl.glEnable(32826);
        this.gl.glMatrixMode(5890);
        this.gl.glLoadIdentity();
        this.gl.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
        this.gl.glMatrixMode(5888);
        this.lastFPS = System.currentTimeMillis();
    }

    private void zeichneAchsen() {
        if (this.achsen) {
            int i;
            this.gl.glDisable(2896);
            this.gl.glEnable(2903);
            this.gl.glDisable(3553);
            this.gl.glLoadIdentity();
            this.glu.gluLookAt(this.renderKamData[0], this.renderKamData[1], this.renderKamData[2], this.renderKamData[3], this.renderKamData[4], this.renderKamData[5], this.renderKamData[6], this.renderKamData[7], this.renderKamData[8]);
            this.gl.glBegin(3);
            for (i = 0; i < 25; i += 2) {
                this.gl.glColor3f(1.0f, 1.0f, 1.0f);
                this.gl.glVertex3f((float)(i * 10), 0.0f, 0.0f);
                this.gl.glColor3f(1.0f, 0.0f, 0.0f);
                this.gl.glVertex3f((float)((i + 1) * 10), 0.0f, 0.0f);
            }
            this.gl.glColor3f(1.0f, 1.0f, 1.0f);
            this.gl.glVertex3f(250.0f, 0.0f, 0.0f);
            this.gl.glVertex3f(240.0f, -5.0f, 0.0f);
            this.gl.glVertex3f(250.0f, 0.0f, 0.0f);
            this.gl.glVertex3f(240.0f, 5.0f, 0.0f);
            this.gl.glEnd();
            this.gl.glBegin(3);
            for (i = 0; i < 25; i += 2) {
                this.gl.glColor3f(1.0f, 1.0f, 1.0f);
                this.gl.glVertex3f(0.0f, (float)(i * 10), 0.0f);
                this.gl.glColor3f(0.0f, 1.0f, 0.0f);
                this.gl.glVertex3f(0.0f, (float)((i + 1) * 10), 0.0f);
            }
            this.gl.glColor3f(1.0f, 1.0f, 1.0f);
            this.gl.glVertex3f(0.0f, 250.0f, 0.0f);
            this.gl.glVertex3f(5.0f, 240.0f, 0.0f);
            this.gl.glVertex3f(0.0f, 250.0f, 0.0f);
            this.gl.glVertex3f(-5.0f, 240.0f, 0.0f);
            this.gl.glEnd();
            this.gl.glBegin(3);
            for (i = 0; i < 25; i += 2) {
                this.gl.glColor3f(1.0f, 1.0f, 1.0f);
                this.gl.glVertex3f(0.0f, 0.0f, (float)(i * 10));
                this.gl.glColor3f(0.0f, 0.0f, 1.0f);
                this.gl.glVertex3f(0.0f, 0.0f, (float)((i + 1) * 10));
            }
            this.gl.glColor3f(1.0f, 1.0f, 1.0f);
            this.gl.glVertex3f(0.0f, 0.0f, 250.0f);
            this.gl.glVertex3f(0.0f, 5.0f, 240.0f);
            this.gl.glVertex3f(0.0f, 0.0f, 250.0f);
            this.gl.glVertex3f(0.0f, -5.0f, 240.0f);
            this.gl.glEnd();
            this.gl.glEnable(2896);
            this.gl.glDisable(2903);
        }
    }

    public void display(GLAutoDrawable drawable) {
        int i;
        this.canvas.requestFocusInWindow();
        for (i = 0; i < GLGlobal.loeschListen.size(); ++i) {
            GLDisplayliste akt = GLGlobal.loeschListen.elementAt(i);
            if (akt.kGL2 != this.gl) continue;
            GLGlobal.loeschListen.remove(akt);
            this.gl.glDeleteLists(akt.displayliste, 1);
        }
        if (GLGlobal.boden != null && GLGlobal.boden.sichtbarkeit && this.kamData[1] < 10.0f) {
            this.kamData[1] = 10.0f;
            this.renderKamData[1] = 10.0f;
            GLVektor up = new GLVektor(this.kamData[6], this.kamData[7], this.kamData[8]);
            GLVektor blick = new GLVektor(this.kamData[3] - this.kamData[0], this.kamData[4] - this.kamData[1], this.kamData[5] - this.kamData[2]);
            up = up.gibKreuzprodukt(blick);
            up = blick.gibKreuzprodukt(up);
            up.normiere();
            this.kamData[6] = (float)up.x;
            this.kamData[7] = (float)up.y;
            this.kamData[8] = (float)up.z;
        }
        if (!this.autoSyncMode) {
            if (System.currentTimeMillis() - this.lastSync > 300L) {
                this.autoSyncMode = true;
                this.updateDarstellung();
            }
        } else {
            this.updateDarstellung();
        }
        if (this.gitterdarstellung) {
            this.gl.glPolygonMode(1032, 6913);
        } else {
            this.gl.glPolygonMode(1032, 6914);
        }
        this.gl.glColorMask(true, true, true, true);
        if (GLGlobal.nebel == null || this.selektionslauf) {
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            this.gl.glDisable(2912);
        } else {
            float[] lF = GLGlobal.nebel.zFarbe;
            this.gl.glClearColor(lF[0], lF[1], lF[2], 1.0f);
        }
        this.gl.glClear(16640);
        for (i = 0; i < 16; ++i) {
            this.gl.glDisable(16384 + i);
        }
        GLGlobal.ambientlicht = false;
        if (this.selektionslauf) {
            this.erstelleSelektionsframe();
        } else if (this.stereomodus) {
            this.erstelleStereoframe();
        } else {
            this.erstelleMonoframe();
        }
        this.frameCount += 1.0;
        double lZeit = System.currentTimeMillis();
        double lDiff = lZeit - this.lastFPS;
        if (lDiff > 500.0) {
            if (lZeit - this.startzeit > 4000.0) {
                if (GLGlobal.KAMERA.renderer == this) {
                    this.frame.setTitle("GLOOP, " + this.version + ", FPS: " + (double)((int)(1000.0 / lDiff * this.frameCount * 100.0)) / 100.0 + ", Primaerkamera");
                } else {
                    this.frame.setTitle("GLOOP, " + this.version + ", FPS: " + (double)((int)(1000.0 / lDiff * this.frameCount * 100.0)) / 100.0 + ", Sekundaerkamera");
                }
            }
            this.frameCount = 0.0;
            this.lastFPS = System.currentTimeMillis();
        }
        if (this.lastFrameTime == 0.0) {
            this.canvas.setVisible(true);
            this.frame.repaint();
        }
        this.lastFrameTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void erstelleStereoframe() {
        Object object = GLGlobal.syncRenderlauf;
        synchronized (object) {
            GLVektor lHoch = new GLVektor(this.renderKamData[6], this.renderKamData[7], this.renderKamData[8]);
            GLVektor lBlick = new GLVektor(this.renderKamData[3], this.renderKamData[4], this.renderKamData[5]);
            lBlick.subtrahiere(new GLVektor(this.renderKamData[0], this.renderKamData[1], this.renderKamData[2]));
            GLVektor lRich = lBlick.gibKreuzprodukt(lHoch);
            lRich.normiere();
            this.gl.glEnable(2896);
            lRich.multipliziere(this.augendistanz);
            this.renderKamData[0] = (float)((double)this.renderKamData[0] + lRich.x);
            this.renderKamData[1] = (float)((double)this.renderKamData[1] + lRich.y);
            this.renderKamData[2] = (float)((double)this.renderKamData[2] + lRich.z);
            this.renderKamData[3] = (float)((double)this.renderKamData[3] + lRich.x);
            this.renderKamData[4] = (float)((double)this.renderKamData[4] + lRich.y);
            this.renderKamData[5] = (float)((double)this.renderKamData[5] + lRich.z);
            this.gl.glColorMask(false, true, true, true);
            this.renderBild(true);
            this.gl.glClear(256);
            lRich.multipliziere(-2.0);
            this.renderKamData[0] = (float)((double)this.renderKamData[0] + lRich.x);
            this.renderKamData[1] = (float)((double)this.renderKamData[1] + lRich.y);
            this.renderKamData[2] = (float)((double)this.renderKamData[2] + lRich.z);
            this.renderKamData[3] = (float)((double)this.renderKamData[3] + lRich.x);
            this.renderKamData[4] = (float)((double)this.renderKamData[4] + lRich.y);
            this.renderKamData[5] = (float)((double)this.renderKamData[5] + lRich.z);
            this.gl.glColorMask(true, false, false, true);
            this.renderBild(true);
            lRich.multipliziere(-0.5);
            this.renderKamData[0] = (float)((double)this.renderKamData[0] + lRich.x);
            this.renderKamData[1] = (float)((double)this.renderKamData[1] + lRich.y);
            this.renderKamData[2] = (float)((double)this.renderKamData[2] + lRich.z);
            this.renderKamData[3] = (float)((double)this.renderKamData[3] + lRich.x);
            this.renderKamData[4] = (float)((double)this.renderKamData[4] + lRich.y);
            this.renderKamData[5] = (float)((double)this.renderKamData[5] + lRich.z);
            this.gl.glColorMask(true, true, true, true);
        }
        if (this.an) {
            this.canvas.swapBuffers();
        }
    }

    private void erstelleSelektionsframe() {
        this.gl.glDisable(2896);
        this.renderBild(false);
        int[] viewport = new int[4];
        this.gl.glGetIntegerv(2978, viewport, 0);
        ByteBuffer pixelFarbe = ByteBuffer.allocate(3);
        this.gl.glReadBuffer(1029);
        this.gl.glPixelStorei(3333, 1);
        this.gl.glReadPixels((int)this.selektionX, viewport[3] - (int)this.selektionY, 1, 1, 6407, 5120, (Buffer)pixelFarbe);
        this.trefferID = pixelFarbe.get(0) * 128 * 128;
        this.trefferID += (long)(pixelFarbe.get(1) * 128);
        this.trefferID += (long)pixelFarbe.get(2);
        this.selektionslauf = false;
    }

    private void erstelleMonoframe() {
        this.gl.glEnable(2896);
        this.renderBild(true);
        if (this.an) {
            this.canvas.swapBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderBild(boolean pAchsen) {
        Object object = GLGlobal.syncRenderlauf;
        synchronized (object) {
            int i;
            this.gl.glMatrixMode(5889);
            this.gl.glLoadIdentity();
            if (GLGlobal.nebel == null || this.selektionslauf) {
                this.glu.gluPerspective((double)((float)this.oeffnungswinkel), (double)this.canvas.getWidth() / (double)this.canvas.getHeight(), 1.0, 25000.0);
            } else {
                this.glu.gluPerspective((double)((float)this.oeffnungswinkel), (double)this.canvas.getWidth() / (double)this.canvas.getHeight(), 1.0, (double)GLGlobal.nebel.zEnddistanz * 1.5);
            }
            this.gl.glViewport(0, 0, (int)((double)this.canvas.getWidth() * this.scaleHiDef), (int)((double)this.canvas.getHeight() * this.scaleHiDef));
            this.gl.glMatrixMode(5888);
            if (GLGlobal.nebel != null && !this.selektionslauf) {
                GLGlobal.nebel.erzeugeNebel(this.gl, this.glu);
            }
            this.gl.glEnable(2884);
            if (GLGlobal.himmel != null && !this.selektionslauf && !this.gitterdarstellung) {
                GLGlobal.himmel.executeGL(this.gl, this.glu, this);
            }
            if (GLGlobal.boden != null && !this.selektionslauf) {
                GLGlobal.boden.executeGL(this.gl, this.glu, this);
            }
            for (i = 0; i < GLGlobal.lichtObjekte.size(); ++i) {
                GLGlobal.lichtObjekte.get(i).executeGL(this.gl, this.glu, this);
            }
            if (!this.selektionslauf) {
                this.zeichneAchsen();
            }
            for (i = 0; i < GLGlobal.solideObjekte.size(); ++i) {
                GLGlobal.solideObjekte.get(i).executeGL(this.gl, this.glu, this);
            }
            this.gl.glDisable(2884);
            this.gl.glDepthMask(false);
            for (i = 0; i < GLGlobal.transparenteObjekte.size(); ++i) {
                GLGlobal.transparenteObjekte.get(i).executeGL(this.gl, this.glu, this);
            }
            this.gl.glDepthMask(true);
            if (!this.selektionslauf) {
                for (i = 0; i < GLGlobal.pfeilObjekte.size(); ++i) {
                    GLGlobal.pfeilObjekte.get(i).executeGL(this.gl, this.glu, this);
                }
            }
            this.gl.glDisable(12288);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDarstellung() {
        Object object = GLGlobal.syncRenderlauf;
        synchronized (object) {
            Object object2 = GLGlobal.syncUpdate;
            synchronized (object2) {
                int i;
                System.arraycopy(this.kamData, 0, this.renderKamData, 0, 9);
                for (i = 0; i < GLGlobal.lichtObjekte.size(); ++i) {
                    GLGlobal.lichtObjekte.get(i).erstelleRendermatrix();
                }
                for (i = 0; i < GLGlobal.solideObjekte.size(); ++i) {
                    GLGlobal.solideObjekte.get(i).erstelleRendermatrix();
                }
                for (i = 0; i < GLGlobal.transparenteObjekte.size(); ++i) {
                    GLGlobal.transparenteObjekte.get(i).erstelleRendermatrix();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GLObjekt getObject(double pX, double pY) {
        int i;
        GLObjekt lTrefferObjekt = null;
        this.selektionX = pX * this.scaleHiDef;
        this.selektionY = pY * this.scaleHiDef;
        while (GLGlobal.KAMERA.renderer.gl == null) {
            Thread.currentThread();
            Thread.yield();
        }
        Object object = GLGlobal.syncRenderlauf;
        synchronized (object) {
            this.selektionslauf = true;
        }
        while (this.selektionslauf) {
            try {
                Thread.currentThread().wait();
            }
            catch (Exception exception) {}
        }
        for (i = 0; i < GLGlobal.lichtObjekte.size() && lTrefferObjekt == null; ++i) {
            if (GLGlobal.lichtObjekte.get((int)i).zID != this.trefferID) continue;
            lTrefferObjekt = GLGlobal.lichtObjekte.get(i);
        }
        for (i = 0; i < GLGlobal.solideObjekte.size() && lTrefferObjekt == null; ++i) {
            if (GLGlobal.solideObjekte.get((int)i).zID != this.trefferID) continue;
            lTrefferObjekt = GLGlobal.solideObjekte.get(i);
        }
        for (i = 0; i < GLGlobal.transparenteObjekte.size() && lTrefferObjekt == null; ++i) {
            if (GLGlobal.transparenteObjekte.get((int)i).zID != this.trefferID) continue;
            lTrefferObjekt = GLGlobal.transparenteObjekte.get(i);
        }
        return lTrefferObjekt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setzeKameradaten(float[] pDaten) {
        Object object = GLGlobal.syncUpdate;
        synchronized (object) {
            System.arraycopy(pDaten, 0, this.kamData, 0, 9);
        }
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
    }

    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    public void dispose(GLAutoDrawable drawable) {
    }
}

