/*
 * Decompiled with CFR 0.152.
 */
package GLOOP;

public class GLVektor {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;

    public GLVektor(double pX, double pY, double pZ) {
        this.x = pX;
        this.y = pY;
        this.z = pZ;
    }

    public GLVektor(double pX1, double pY1, double pZ1, double pX2, double pY2, double pZ2) {
        this.x = pX1 - pX2;
        this.y = pY1 - pY2;
        this.z = pZ1 - pZ2;
    }

    public void normiere() {
        double lBetrag = this.gibBetrag();
        if (lBetrag != 0.0) {
            this.x /= lBetrag;
            this.y /= lBetrag;
            this.z /= lBetrag;
        }
    }

    public double gibBetrag() {
        return Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0));
    }

    public void setzeKomponenten(double pX, double pY, double pZ) {
        this.x = pX;
        this.y = pY;
        this.z = pZ;
    }

    public void setzeKomponenten(GLVektor pV) {
        this.setzeKomponenten(pV.gibX(), pV.gibY(), pV.gibZ());
    }

    public void addiere(GLVektor pV) {
        this.x += pV.x;
        this.y += pV.y;
        this.z += pV.z;
    }

    public void subtrahiere(GLVektor pV) {
        this.x -= pV.x;
        this.y -= pV.y;
        this.z -= pV.z;
    }

    public void multipliziere(double pS) {
        this.x *= pS;
        this.y *= pS;
        this.z *= pS;
    }

    public GLVektor gibVielfaches(double pS) {
        GLVektor ergebnis = new GLVektor(this);
        ergebnis.multipliziere(pS);
        return ergebnis;
    }

    public GLVektor gibSumme(GLVektor pV) {
        GLVektor ergebnis = new GLVektor(this);
        ergebnis.addiere(pV);
        return ergebnis;
    }

    public GLVektor gibDifferenz(GLVektor pV) {
        GLVektor ergebnis = new GLVektor(this);
        ergebnis.subtrahiere(pV);
        return ergebnis;
    }

    public GLVektor gibNormierung() {
        GLVektor ergebnis = new GLVektor(this);
        ergebnis.normiere();
        return ergebnis;
    }

    public GLVektor gibKreuzprodukt(GLVektor pV) {
        return new GLVektor(this.y * pV.z - this.z * pV.y, this.z * pV.x - this.x * pV.z, this.x * pV.y - this.y * pV.x);
    }

    public double gibSkalarprodukt(GLVektor pV) {
        return this.x * pV.x + this.y * pV.y + this.z * pV.z;
    }

    public void skaliereAuf(double pBetrag) {
        double lB = this.gibBetrag();
        if (lB != 0.0) {
            this.x = this.x / lB * pBetrag;
            this.y = this.y / lB * pBetrag;
            this.z = this.z / lB * pBetrag;
        }
    }

    public void rotiere(double pWinkel, double pNX, double pNY, double pNZ) {
        float n = (float)Math.sqrt(pNX * pNX + pNY * pNY + pNZ * pNZ);
        float x = (float)pNX / n;
        float y = (float)pNY / n;
        float z = (float)pNZ / n;
        float[] lD = new float[9];
        float c = (float)Math.cos(pWinkel / 180.0 * Math.PI);
        float s = (float)Math.sin(pWinkel / 180.0 * Math.PI);
        lD[0] = (y * y + z * z) * c + x * x;
        lD[1] = x * y * (1.0f - c) + z * s;
        lD[2] = x * z * (1.0f - c) - y * s;
        lD[3] = x * y * (1.0f - c) - z * s;
        lD[4] = (x * x + z * z) * c + y * y;
        lD[5] = y * z * (1.0f - c) + x * s;
        lD[6] = x * z * (1.0f - c) + y * s;
        lD[7] = y * z * (1.0f - c) - x * s;
        lD[8] = (x * x + y * y) * c + z * z;
        float[] lR = new float[3];
        float[] lRa = new float[]{(float)this.x, (float)this.y, (float)this.z};
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 3; ++k) {
                int n2 = j;
                lR[n2] = lR[n2] + lRa[k] * lD[k * 3 + j];
            }
        }
        this.x = lR[0];
        this.y = lR[1];
        this.z = lR[2];
    }

    public void drehe(double pWX, double pWY, double pWZ) {
        this.rotiere(pWX, 1.0, 0.0, 0.0);
        this.rotiere(pWY, 0.0, 1.0, 0.0);
        this.rotiere(pWZ, 0.0, 0.0, 1.0);
    }

    public double gibX() {
        return this.x;
    }

    public double gibY() {
        return this.y;
    }

    public double gibZ() {
        return this.z;
    }

    public GLVektor(GLVektor pV) {
        this(pV.x, pV.y, pV.z);
    }

    public GLVektor(GLVektor lV1, GLVektor lV2) {
        this(lV1.x, lV1.y, lV1.z, lV2.x, lV2.y, lV2.z);
    }

    public void rotiere(double pWinkel, GLVektor pVN) {
        this.rotiere(pWinkel, pVN.x, pVN.y, pVN.z);
    }

    public double gibWinkel(GLVektor pVektor) {
        GLVektor s = new GLVektor(this);
        GLVektor v = new GLVektor(pVektor);
        s.normiere();
        v.normiere();
        double skalarProdukt = s.gibSkalarprodukt(v);
        double winkel = Math.acos(skalarProdukt) * 57.29577951308232;
        return winkel;
    }
}

