/*
 * Decompiled with CFR 0.152.
 */
package GLOOP;

import GLOOP.GLGlobal;
import GLOOP.GLObjekt;
import GLOOP.GLRenderer;
import GLOOP.GLVektor;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;

public class GLLicht
extends GLObjekt {
    int zNummer;
    float[] ambient = new float[]{0.8f, 0.8f, 0.8f, 1.0f};
    float[] diffuse = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    float[] spekular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    double zAbschwaechung = 0.0;
    GLUquadric quad;

    public GLLicht() {
        this(-10000.0, 10000.0, 10000.0);
    }

    public GLLicht(double pX, double pY, double pZ) {
        boolean frei;
        this.matrix[12] = (float)pX;
        this.matrix[13] = (float)pY;
        this.matrix[14] = (float)pZ;
        this.zNummer = -1;
        do {
            ++this.zNummer;
            frei = true;
            for (int i = 0; i < GLGlobal.lichtObjekte.size(); ++i) {
                GLObjekt lE = GLGlobal.lichtObjekte.get(i);
                if (!(lE instanceof GLLicht) || ((GLLicht)lE).zNummer != this.zNummer) continue;
                frei = false;
            }
        } while (!frei);
        this.sichtbarkeit = false;
        GLGlobal.solideObjekte.remove(this);
        GLGlobal.einfuegenLicht(this);
    }

    @Override
    protected void executeGL(GL2 gl, GLU glu, GLRenderer pRenderer) {
        if (this.sichtbarkeit) {
            super.executeGL(gl, glu, pRenderer);
        } else {
            gl.glLoadIdentity();
            glu.gluLookAt(pRenderer.renderKamData[0], pRenderer.renderKamData[1], pRenderer.renderKamData[2], pRenderer.renderKamData[3], pRenderer.renderKamData[4], pRenderer.renderKamData[5], pRenderer.renderKamData[6], pRenderer.renderKamData[7], pRenderer.renderKamData[8]);
            gl.glMultMatrixf(this.matrix, 0);
        }
        float[] lL = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        gl.glLightfv(16384 + this.zNummer, 4611, lL, 0);
        if (!GLGlobal.ambientlicht) {
            gl.glLightfv(16384 + this.zNummer, 4608, this.ambient, 0);
            GLGlobal.ambientlicht = true;
        }
        gl.glLightfv(16384 + this.zNummer, 4609, this.diffuse, 0);
        gl.glLightfv(16384 + this.zNummer, 4610, this.spekular, 0);
        gl.glLightf(16384 + this.zNummer, 4616, (float)this.zAbschwaechung);
        gl.glEnable(16384 + this.zNummer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setzePosition(double pX, double pY, double pZ) {
        Object object = GLGlobal.syncRenderlauf;
        synchronized (object) {
            super.setzePosition(pX, pY, pZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verschiebe(double pX, double pY, double pZ) {
        Object object = GLGlobal.syncRenderlauf;
        synchronized (object) {
            super.verschiebe(pX, pY, pZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotiere(double pWinkel, double pNX, double pNY, double pNZ, double pRX, double pRY, double pRZ) {
        Object object = GLGlobal.syncRenderlauf;
        synchronized (object) {
            super.rotiere(pWinkel, pNX, pNY, pNZ, pRX, pRY, pRZ);
        }
    }

    @Override
    public void zeichneObjekt(GL2 gl, GLU glu) {
        if (this.quad == null) {
            this.quad = glu.gluNewQuadric();
        }
        if (this.tex != null) {
            glu.gluQuadricTexture(this.quad, true);
        }
        gl.glMaterialfv(1028, 5632, this.diffuse, 0);
        glu.gluSphere(this.quad, 10.0, 16, 16);
    }

    public void setzeHintergrundlicht(double r, double g, double b) {
        this.ambient[0] = (float)r;
        this.ambient[1] = (float)g;
        this.ambient[2] = (float)b;
    }

    @Override
    public void setzeFarbe(double r, double g, double b) {
        this.diffuse[0] = (float)r;
        this.diffuse[1] = (float)g;
        this.diffuse[2] = (float)b;
    }

    public void setzeGlanzlicht(double r, double g, double b) {
        this.spekular[0] = (float)r;
        this.spekular[1] = (float)g;
        this.spekular[2] = (float)b;
    }

    public void setzeAbschwaechung(double pA) {
        this.zAbschwaechung = pA;
    }

    public GLLicht(GLVektor pPosition) {
        this(pPosition.x, pPosition.y, pPosition.z);
    }
}

