/*
 * Decompiled with CFR 0.152.
 */
package GLOOP;

import GLOOP.GLGlobal;
import GLOOP.GLObjekt;
import GLOOP.GLRenderer;
import GLOOP.GLTextur;
import GLOOP.GLVektor;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;

public class GLTafel
extends GLObjekt {
    float zLX;
    float zLY;
    boolean zBeleuchtung = false;
    boolean zKamerafixierung = false;
    boolean zAutoDrehung = false;
    boolean autoskalierung = true;
    float[] zTextfarbe = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    float zFR;
    float zFU;
    float zFB;
    int zFX;
    int zFY;
    int zFaecherung = 1;
    int achsenfixierung = 0;
    int ausrichtung = 0;
    boolean zSetzeFensterposition = false;
    String zText;
    double zGroesse;

    public GLTafel(double pX, double pY, double pZ, double pLX, double pLY, GLTextur pT) {
        this(pX, pY, pZ, pLX, pLY);
        this.setzeTextur(pT);
    }

    public GLTafel(double pX, double pY, double pZ, double pLX, double pLY, String pT) {
        this(pX, pY, pZ, pLX, pLY);
        this.setzeTextur(new GLTextur(pT));
    }

    public GLTafel(double pX, double pY, double pZ, double pLX, double pLY) {
        this.matrix[12] = (float)pX;
        this.matrix[13] = (float)pY;
        this.matrix[14] = (float)pZ;
        this.zLX = (float)pLX;
        this.zLY = (float)pLY;
        this.setzeText("", 1.0);
        this.setzeBeleuchtung(false);
    }

    public void setzeFaecherung(int pFaecheranzahl) {
        this.zFaecherung = pFaecheranzahl;
        this.resetDisplayliste();
    }

    public void setzeKamerafixierung(boolean pF) {
        this.zKamerafixierung = pF;
        if (this.zKamerafixierung) {
            float[] lKam = GLGlobal.KAMERA.kamData;
            GLVektor lU = new GLVektor(lKam[6], lKam[7], lKam[8]);
            lU.normiere();
            GLVektor lB = new GLVektor(lKam[3] - lKam[0], lKam[4] - lKam[1], lKam[5] - lKam[2]);
            lB.normiere();
            GLVektor lR = lU.gibKreuzprodukt(lB);
            lR.normiere();
            lU = lB.gibKreuzprodukt(lR);
            GLVektor lP = new GLVektor(lKam[0], lKam[1], lKam[2]);
            GLVektor lRich = new GLVektor(this.gibX(), this.gibY(), this.gibZ(), lP.x, lP.y, lP.z);
            float lEntfernung = (float)lRich.gibBetrag();
            lRich.normiere();
            this.zFR = (float)lR.gibSkalarprodukt(lRich);
            this.zFU = (float)lU.gibSkalarprodukt(lRich);
            this.zFB = (float)lB.gibSkalarprodukt(lRich);
            this.zFR *= lEntfernung;
            this.zFU *= lEntfernung;
            this.zFB *= lEntfernung;
        }
    }

    public void setzeAutodrehung(boolean pD) {
        this.zAutoDrehung = pD;
        this.achsenfixierung = 0;
    }

    public void setzeAutodrehung(boolean pD, int pAchsenfixierung) {
        this.zAutoDrehung = pD;
        this.achsenfixierung = pAchsenfixierung;
    }

    public void setzeAutoskalierung(boolean pAutoskalierung) {
        this.autoskalierung = pAutoskalierung;
    }

    public void setzeText(String pText, double pGroesse) {
        this.zText = pText;
        this.zGroesse = pGroesse;
        if (this.autoskalierung) {
            if ((double)this.zLY < this.zGroesse) {
                this.zLY = (float)this.zGroesse;
            }
            if ((double)this.zLX < this.zGroesse * (double)(this.zText.length() + 1) * (double)0.6f) {
                this.zLX = (float)(this.zGroesse * (double)(this.zText.length() + 1) * (double)0.6f);
            }
        }
        this.resetDisplayliste();
    }

    public String gibText() {
        return this.zText;
    }

    public void setzeTextfarbe(double pR, double pG, double pB) {
        this.zTextfarbe[0] = (float)pR;
        this.zTextfarbe[1] = (float)pG;
        this.zTextfarbe[2] = (float)pB;
        this.resetDisplayliste();
    }

    @Override
    void executeGL(GL2 gl, GLU glu, GLRenderer pRenderer) {
        if (!this.zKamerafixierung || pRenderer == GLGlobal.KAMERA.renderer) {
            if (this.zFaecherung == 1 && (this.zAutoDrehung || this.zKamerafixierung)) {
                float[] lKam = pRenderer.renderKamData;
                GLVektor lU = new GLVektor(lKam[6], lKam[7], lKam[8]);
                lU.normiere();
                GLVektor lB = new GLVektor(lKam[3] - lKam[0], lKam[4] - lKam[1], lKam[5] - lKam[2]);
                lB.normiere();
                GLVektor lR = lU.gibKreuzprodukt(lB);
                lR.normiere();
                lU = lB.gibKreuzprodukt(lR);
                GLVektor lP = new GLVektor(lKam[0], lKam[1], lKam[2]);
                if (this.zAutoDrehung) {
                    if (this.achsenfixierung == 1) {
                        lR.x = 1.0;
                        lR.y = 0.0;
                        lR.z = 0.0;
                        lU = lB.gibKreuzprodukt(lR);
                        lU.normiere();
                        lB = lR.gibKreuzprodukt(lU);
                        lB.normiere();
                    } else if (this.achsenfixierung == 2) {
                        lU.x = 0.0;
                        lU.y = 1.0;
                        lU.z = 0.0;
                        lR = lU.gibKreuzprodukt(lB);
                        lR.normiere();
                        lB = lR.gibKreuzprodukt(lU);
                        lB.normiere();
                    } else if (this.achsenfixierung == 3) {
                        lB.x = 0.0;
                        lB.y = 0.0;
                        lB.z = 1.0;
                        lU = lB.gibKreuzprodukt(lR);
                        lU.normiere();
                        lR = lU.gibKreuzprodukt(lB);
                        lR.normiere();
                    }
                    this.matrix[0] = (float)(-lR.x) * this.scaleX;
                    this.matrix[1] = (float)(-lR.y) * this.scaleY;
                    this.matrix[2] = (float)(-lR.z) * this.scaleZ;
                    this.matrix[4] = (float)lU.x * this.scaleX;
                    this.matrix[5] = (float)lU.y * this.scaleY;
                    this.matrix[6] = (float)lU.z * this.scaleZ;
                    this.matrix[8] = (float)(-lB.x) * this.scaleX;
                    this.matrix[9] = (float)(-lB.y) * this.scaleY;
                    this.matrix[10] = (float)(-lB.z) * this.scaleZ;
                }
                if (this.zKamerafixierung && pRenderer == GLGlobal.KAMERA.renderer) {
                    lR.multipliziere(this.zFR);
                    lU.multipliziere(this.zFU);
                    lB.multipliziere(this.zFB);
                    GLVektor lPos = new GLVektor(0.0, 0.0, 0.0);
                    lPos.addiere(lR);
                    lPos.addiere(lU);
                    lPos.addiere(lB);
                    this.setzePosition(lP.x + lPos.x, lP.y + lPos.y, lP.z + lPos.z);
                }
                this.erstelleRendermatrix();
            }
            if (this.zText.length() > 0 && GLGlobal.ZEICHEN.gibGLTextur(gl) == null) {
                GLGlobal.ZEICHEN.ladeGLTextur(gl);
            }
            super.executeGL(gl, glu, pRenderer);
        }
    }

    @Override
    public void zeichneObjekt(GL2 gl, GLU glu) {
        gl.glDisable(2884);
        float zHSX = this.zLX / 2.0f;
        float zHSY = this.zLY / 2.0f;
        for (int j = 0; j < this.zFaecherung; ++j) {
            gl.glMaterialfv(1028, 4609, this.diffuse, 0);
            if (!this.zBeleuchtung) {
                gl.glMaterialfv(1028, 5632, this.emission, 0);
            }
            gl.glBegin(7);
            gl.glNormal3d(0.0, 0.0, 1.0);
            gl.glTexCoord2f(1.0f, 1.0f);
            gl.glVertex3f(-zHSX, -zHSY, 0.0f);
            gl.glTexCoord2f(0.0f, 1.0f);
            gl.glVertex3f(zHSX, -zHSY, 0.0f);
            gl.glTexCoord2f(0.0f, 0.0f);
            gl.glVertex3f(zHSX, zHSY, 0.0f);
            gl.glTexCoord2f(1.0f, 0.0f);
            gl.glVertex3f(-zHSX, zHSY, 0.0f);
            gl.glEnd();
            if (this.zText.length() > 0 && !GLGlobal.KAMERA.renderer.selektionslauf) {
                float lX = 0.0f;
                if (this.ausrichtung == 0) {
                    lX = (float)(-(this.zGroesse * 0.6 * (double)(this.zText.length() - 1))) / 2.0f;
                }
                if (this.ausrichtung == 1) {
                    lX = zHSX - (float)(this.zGroesse * 0.6 * (double)(this.zText.length() - 1)) - (float)this.zGroesse / 2.0f;
                }
                if (this.ausrichtung == -1) {
                    lX = -zHSX + (float)this.zGroesse / 2.0f;
                }
                float lY = 0.0f;
                gl.glMaterialfv(1028, 4609, this.zTextfarbe, 0);
                if (!this.zBeleuchtung) {
                    gl.glMaterialfv(1028, 5632, this.zTextfarbe, 0);
                }
                gl.glEnable(3553);
                GLGlobal.ZEICHEN.gibGLTextur(gl).bind((GL)gl);
                for (int i = 0; i < this.zText.length(); ++i) {
                    char lZ = this.zText.charAt(i);
                    float lTX = lZ % 16;
                    float lTY = lZ / 16;
                    lTY /= 16.0f;
                    float leftZ = (float)((double)lX - this.zGroesse / 2.0);
                    float rightZ = (float)((double)lX + this.zGroesse / 2.0);
                    float leftT = lTX /= 16.0f;
                    float rightT = lTX + 0.0625f;
                    if (!(leftZ < -zHSX && rightZ < -zHSX || zHSX < leftZ && zHSX < rightZ)) {
                        float diff;
                        gl.glBegin(7);
                        gl.glNormal3d(0.0, 0.0, 1.0);
                        if (-zHSX > leftZ) {
                            diff = Math.abs(-zHSX - leftZ) / (float)this.zGroesse;
                            leftT += diff / 16.0f;
                            leftZ = -zHSX;
                        }
                        if (zHSX < rightZ) {
                            diff = Math.abs(zHSX - rightZ) / (float)this.zGroesse;
                            rightT -= diff / 16.0f;
                            rightZ = zHSX;
                        }
                        gl.glTexCoord2f(leftT, lTY + 0.0625f);
                        gl.glVertex3f(leftZ, (float)((double)lY - this.zGroesse / 2.0), 0.2f);
                        gl.glTexCoord2f(rightT, lTY + 0.0625f);
                        gl.glVertex3f(rightZ, (float)((double)lY - this.zGroesse / 2.0), 0.2f);
                        gl.glTexCoord2f(rightT, lTY);
                        gl.glVertex3f(rightZ, (float)((double)lY + this.zGroesse / 2.0), 0.2f);
                        gl.glTexCoord2f(leftT, lTY);
                        gl.glVertex3f(leftZ, (float)((double)lY + this.zGroesse / 2.0), 0.2f);
                        gl.glEnd();
                    }
                    lX = (float)((double)lX + this.zGroesse * 0.6);
                }
                GLGlobal.ZEICHEN.gibGLTextur(gl).disable((GL)gl);
            }
            gl.glRotatef((float)(180 / this.zFaecherung), 0.0f, 1.0f, 0.0f);
        }
    }

    public void setzeBeleuchtung(boolean pB) {
        if (!pB) {
            this.setzeSelbstleuchten(this.diffuse[0], this.diffuse[1], this.diffuse[2]);
        } else {
            this.setzeSelbstleuchten(0.0, 0.0, 0.0);
        }
        this.zBeleuchtung = pB;
    }

    @Override
    public void setzeFarbe(double pR, double pG, double pB) {
        super.setzeFarbe(pR, pG, pB);
        this.setzeBeleuchtung(this.zBeleuchtung);
    }

    public void setzeAusrichtung(int pAusrichtung) {
        this.ausrichtung = pAusrichtung;
        this.resetDisplayliste();
    }

    public void setzeBildposition(double pX, double pY) {
        this.setzeKamerafixierung(false);
        float[] lKam = GLGlobal.KAMERA.kamData;
        GLVektor lU = new GLVektor(lKam[6], lKam[7], lKam[8]);
        lU.normiere();
        GLVektor lB = new GLVektor(lKam[3] - lKam[0], lKam[4] - lKam[1], lKam[5] - lKam[2]);
        lB.normiere();
        GLVektor lR = lU.gibKreuzprodukt(lB);
        lR.normiere();
        lU = lB.gibKreuzprodukt(lR);
        GLVektor lP = new GLVektor(lKam[0], lKam[1], lKam[2]);
        double lBreite = GLGlobal.KAMERA.gibBreite();
        double lHoehe = GLGlobal.KAMERA.gibHoehe();
        GLVektor lFix = new GLVektor(lB).gibVielfaches(5.0);
        double lWX = pX / (lBreite / 2.0);
        double lWY = pY / (lHoehe / 2.0);
        lWX = 30.0 * (lBreite / lHoehe) * lWX;
        lWY = 30.0 * lWY;
        lFix.rotiere(-lWX, lU);
        lFix.rotiere(-lWY, lR);
        if (lFix.z > 0.0) {
            lFix.multipliziere(5.0 / lFix.z);
        } else {
            lFix.multipliziere(-5.0 / lFix.z);
        }
        lFix.addiere(lP);
        this.setzeSkalierung((double)this.zLX / (lBreite * 5.0 * 2.0));
        this.setzePosition(lFix);
        this.setzeKamerafixierung(true);
        this.setzeAutodrehung(true);
    }

    public GLTafel(GLVektor pPosition, double pLX, double pLY, GLTextur pT) {
        this(pPosition.x, pPosition.y, pPosition.z, pLX, pLY, pT);
    }

    public GLTafel(GLVektor pPosition, double pLX, double pLY, String pT) {
        this(pPosition.x, pPosition.y, pPosition.z, pLX, pLY, pT);
    }

    public GLTafel(GLVektor pPosition, double pLX, double pLY) {
        this(pPosition.x, pPosition.y, pPosition.z, pLX, pLY);
    }
}

