/*
 * Decompiled with CFR 0.152.
 */
package GLOOP;

import GLOOP.GLGlobal;
import GLOOP.GLObjekt;
import GLOOP.GLVektor;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class GLTerrain
extends GLObjekt {
    float[][] hMap = new float[512][512];
    float zBreite = 512.0f;
    float zHoehe = 256.0f;
    float zLaenge = 512.0f;
    boolean zBereit = false;
    boolean zFaceculling = true;
    int zQualitaet;

    public GLTerrain(double pX, double pY, double pZ, String pHightmap) {
        GLGlobal.solideObjekte.remove(this);
        this.matrix[12] = (float)pX;
        this.matrix[13] = (float)pY;
        this.matrix[14] = (float)pZ;
        try {
            BufferedImage lHoeheTex = ImageIO.read(new File(pHightmap));
            for (int i = 0; i < 512; ++i) {
                for (int j = 0; j < 512; ++j) {
                    Color lC = new Color(lHoeheTex.getRGB(i, j));
                    this.hMap[i][j] = (float)lC.getRed() / 255.0f;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.zQualitaet = 85;
        this.zBereit = true;
        GLGlobal.einfuegenSolid(this);
    }

    public double gibHoehe(double pX, double pZ) {
        while (!this.zBereit) {
            Thread.currentThread();
            Thread.yield();
        }
        int lX = (int)((pX + (double)(this.zBreite / 2.0f)) / (double)(this.zBreite / 512.0f));
        int lZ = (int)((pZ + (double)(this.zLaenge / 2.0f)) / (double)(this.zLaenge / 512.0f));
        if (lX >= 0 && lX < 512 && lZ >= 0 && lZ < 512) {
            return this.hMap[lX][lZ] * this.zHoehe;
        }
        return 0.0;
    }

    public void setzeHoehen(float[][] pH) {
        this.hMap = pH;
        this.resetDisplayliste();
    }

    private GLVektor berechneNormalenvektor(int x, int y, double pTFac) {
        GLVektor lN;
        if (x == 0 || y == 0 || x == this.zQualitaet || y == this.zQualitaet) {
            lN = new GLVektor(0.0, 1.0, 0.0);
        } else {
            GLVektor lA = new GLVektor(pTFac, (this.hMap[(int)((double)(x + 1) * pTFac)][(int)((double)y * pTFac)] - this.hMap[(int)((double)x * pTFac)][(int)((double)y * pTFac)]) * 255.0f, 0.0);
            GLVektor lB = new GLVektor(-pTFac, (this.hMap[(int)((double)(x - 1) * pTFac)][(int)((double)y * pTFac)] - this.hMap[(int)((double)x * pTFac)][(int)((double)y * pTFac)]) * 255.0f, 0.0);
            GLVektor lC = new GLVektor(0.0, (this.hMap[(int)((double)x * pTFac)][(int)((double)(y + 1) * pTFac)] - this.hMap[(int)((double)x * pTFac)][(int)((double)y * pTFac)]) * 255.0f, pTFac);
            GLVektor lD = new GLVektor(0.0, (this.hMap[(int)((double)x * pTFac)][(int)((double)(y - 1) * pTFac)] - this.hMap[(int)((double)x * pTFac)][(int)((double)y * pTFac)]) * 255.0f, -pTFac);
            lN = lD.gibKreuzprodukt(lB);
            lN.addiere(lA.gibKreuzprodukt(lD));
            lN.addiere(lC.gibKreuzprodukt(lA));
            lN.addiere(lB.gibKreuzprodukt(lC));
            lN.normiere();
        }
        return lN;
    }

    @Override
    public void zeichneObjekt(GL2 gl, GLU glu) {
        while (!this.zBereit) {
            Thread.currentThread();
            Thread.yield();
        }
        if (this.zFaceculling) {
            gl.glEnable(2884);
        } else {
            gl.glDisable(2884);
        }
        double lTFac = 511.0f / (float)this.zQualitaet;
        for (int i = 0; i < this.zQualitaet; ++i) {
            gl.glBegin(5);
            for (int j = this.zQualitaet; j >= 0; --j) {
                GLVektor lN = this.berechneNormalenvektor(i, j, lTFac);
                gl.glNormal3f((float)lN.x, (float)lN.y, (float)lN.z);
                gl.glTexCoord2f((float)((double)i * lTFac / 511.0), (float)((double)j * lTFac / 511.0));
                gl.glVertex3f((float)((double)i * lTFac / 511.0 * (double)this.zBreite - (double)(this.zBreite / 2.0f)), this.hMap[(int)((double)i * lTFac)][(int)((double)j * lTFac)] * this.zHoehe, (float)((double)j * lTFac / 511.0 * (double)this.zLaenge - (double)(this.zLaenge / 2.0f)));
                lN = this.berechneNormalenvektor(i + 1, j, lTFac);
                gl.glNormal3f((float)lN.x, (float)lN.y, (float)lN.z);
                gl.glTexCoord2f((float)((double)(i + 1) * lTFac / 511.0), (float)((double)j * lTFac / 511.0));
                gl.glVertex3f((float)((double)(i + 1) * lTFac / 511.0 * (double)this.zBreite - (double)(this.zBreite / 2.0f)), this.hMap[(int)((double)(i + 1) * lTFac)][(int)((double)j * lTFac)] * this.zHoehe, (float)((double)j * lTFac / 511.0 * (double)this.zLaenge - (double)(this.zLaenge / 2.0f)));
            }
            gl.glEnd();
        }
        gl.glEnable(2884);
    }

    @Override
    public void skaliere(double pX, double pY, double pZ) {
        this.zBreite = (float)((double)this.zBreite * pX);
        this.zHoehe = (float)((double)this.zHoehe * pY);
        this.zLaenge = (float)((double)this.zLaenge * pZ);
        this.scaleX = (float)((double)this.scaleX * pX);
        this.scaleY = (float)((double)this.scaleY * pY);
        this.scaleZ = (float)((double)this.scaleZ * pZ);
        this.resetDisplayliste();
    }

    public void setzeAbmessungen(double pBreite, double pHoehe, double pTiefe) {
        this.zBreite = (float)pBreite;
        this.zHoehe = (float)pHoehe;
        this.zLaenge = (float)pTiefe;
        this.resetDisplayliste();
    }

    public void zeigeUnterseite(boolean pU) {
        this.zFaceculling = !pU;
        this.resetDisplayliste();
    }

    @Override
    public void setzeQualitaet(int pQ) {
        this.zQualitaet = pQ;
        this.resetDisplayliste();
    }

    public GLTerrain(GLVektor pPosition, String pHightmap) {
        this(pPosition.x, pPosition.y, pPosition.z, pHightmap);
    }
}

