/*
 * Decompiled with CFR 0.152.
 */
package GLOOP;

import GLOOP.GLGlobal;
import GLOOP.GLObjekt;
import GLOOP.GLTextur;
import GLOOP.GLVektor;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;

public class GLTorus
extends GLObjekt {
    private float zRadius;
    private float zDicke;
    private int zQ1 = 0;
    private int zQ2 = 0;

    public GLTorus(double pX, double pY, double pZ, double pRadius, double pDicke, GLTextur pT) {
        this(pX, pY, pZ, pRadius, pDicke);
        this.setzeTextur(pT);
    }

    public GLTorus(double pX, double pY, double pZ, double pRadius, double pDicke, String pT) {
        this(pX, pY, pZ, pRadius, pDicke);
        this.setzeTextur(new GLTextur(pT));
    }

    public GLTorus(double pX, double pY, double pZ, double pRadius, double pDicke) {
        this.matrix[12] = (float)pX;
        this.matrix[13] = (float)pY;
        this.matrix[14] = (float)pZ;
        this.zRadius = (float)pRadius;
        this.zDicke = (float)pDicke;
    }

    void berechneQualitaet() {
        double lDist = Math.sqrt(Math.pow((double)this.matrix[12] - GLGlobal.KAMERA.gibX(), 2.0) + Math.pow((double)this.matrix[13] - GLGlobal.KAMERA.gibY(), 2.0) + Math.pow((double)this.matrix[14] - GLGlobal.KAMERA.gibZ(), 2.0));
        this.zQ1 = (int)(lDist * (double)(250.0f / (this.zRadius * this.skalierung)) * -0.006 + 43.0);
        if (this.zQ1 < 12) {
            this.zQ1 = 12;
        }
        if (this.zQ1 > 40) {
            this.zQ1 = 40;
        }
        this.zQ2 = (int)(lDist * (double)(250.0f / (this.zDicke * this.skalierung)) * -0.006 + 43.0);
        if (this.zQ2 < 12) {
            this.zQ2 = 12;
        }
        if (this.zQ2 > 40) {
            this.zQ2 = 40;
        }
    }

    @Override
    public void setzeQualitaet(int pQ) {
        this.zQ1 = pQ;
        this.zQ2 = pQ;
        this.resetDisplayliste();
    }

    @Override
    public void zeichneObjekt(GL2 gl, GLU glu) {
        if (this.zQ1 == 0 && this.zQ2 == 0) {
            this.berechneQualitaet();
        }
        gl.glEnable(2884);
        float R = this.zRadius;
        float r = this.zDicke;
        float ringDelta = (float)Math.PI * 2 / (float)this.zQ1;
        float sideDelta = (float)Math.PI * 2 / (float)this.zQ2;
        float theta = 0.0f;
        float cosTheta = 1.0f;
        float sinTheta = 0.0f;
        for (int i = this.zQ1 - 1; i >= 0; --i) {
            float theta1 = theta + ringDelta;
            float cosTheta1 = (float)Math.cos(theta1);
            float sinTheta1 = (float)Math.sin(theta1);
            gl.glBegin(5);
            float phi = 0.0f;
            for (int j = this.zQ2; j >= 0; --j) {
                float cosPhi = (float)Math.cos(phi += sideDelta);
                float sinPhi = (float)Math.sin(phi);
                float dist = R + r * cosPhi;
                gl.glTexCoord2f((float)i / (float)this.zQ1, (float)j / (float)this.zQ2);
                gl.glNormal3f(cosTheta1 * cosPhi, -sinTheta1 * cosPhi, sinPhi);
                gl.glVertex3f(cosTheta1 * dist, -sinTheta1 * dist, r * sinPhi);
                gl.glTexCoord2f((float)(i + 1) / (float)this.zQ1, (float)j / (float)this.zQ2);
                gl.glNormal3f(cosTheta * cosPhi, -sinTheta * cosPhi, sinPhi);
                gl.glVertex3f(cosTheta * dist, -sinTheta * dist, r * sinPhi);
            }
            gl.glEnd();
            theta = theta1;
            cosTheta = cosTheta1;
            sinTheta = sinTheta1;
        }
        if (this.ambient[3] != 1.0f && this.diffuse[3] != 1.0f && this.spekular[3] != 1.0f) {
            gl.glDisable(2884);
        }
    }

    public GLTorus(GLVektor pPosition, double pRadius, double pDicke, GLTextur pT) {
        this(pPosition.x, pPosition.y, pPosition.z, pRadius, pDicke, pT);
    }

    public GLTorus(GLVektor pPosition, double pRadius, double pDicke, String pT) {
        this(pPosition.x, pPosition.y, pPosition.z, pRadius, pDicke, pT);
    }

    public GLTorus(GLVektor pPosition, double pRadius, double pDicke) {
        this(pPosition.x, pPosition.y, pPosition.z, pRadius, pDicke);
    }
}

